/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import de.willuhn.io.AbstractZipSupport;
import de.willuhn.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCreator
extends AbstractZipSupport {
    private ZipOutputStream target = null;
    private boolean running = false;

    public ZipCreator(OutputStream os) {
        this.target = new ZipOutputStream(os);
    }

    public void close() throws IOException {
        if (this.target != null) {
            try {
                this.target.close();
                this.monitor.setPercentComplete(100);
                this.monitor.setStatusText("zip file created successfully");
                this.monitor.setStatus(4);
            }
            catch (IOException e) {
                this.monitor.setStatus(3);
                throw e;
            }
        }
    }

    public void add(File entry) throws IOException {
        this._add(entry.getName(), entry);
    }

    private void _add(String zipPath, File handle) throws IOException {
        if (!handle.exists()) {
            return;
        }
        if (!handle.canRead()) {
            throw new IOException("cannot read " + handle.getAbsolutePath());
        }
        if (!this.running) {
            this.monitor.setStatus(2);
            this.running = true;
        }
        if (handle.isDirectory()) {
            File[] children = handle.listFiles();
            if (children.length == 0) {
                this.target.putNextEntry(new ZipEntry(zipPath + "/"));
                this.target.closeEntry();
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this._add(zipPath + "/" + children[i].getName(), children[i]);
            }
            return;
        }
        try {
            this.monitor.addPercentComplete(1);
            this.monitor.log("    adding file " + zipPath);
            this.target.putNextEntry(new ZipEntry(zipPath));
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(handle));
            IOUtil.copy(is, this.target);
            this.target.closeEntry();
            ((InputStream)is).close();
        }
        catch (IOException e) {
            this.monitor.setStatus(3);
            throw e;
        }
    }
}

